;;; -*- Mode: Common-Lisp; Package: User; Base: 10.; Patch-File: T -*-

;;; Reason: Changed nearest-circle-pt to return correct values when the 
;;; point is outside the circle.

;;;                           RESTRICTED RIGHTS LEGEND
;;;
;;; Use, duplication, or disclosure by the Government is subject to
;;; restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;; Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;   TEXAS INSTRUMENTS INCORPORATED      
;;;   P.O. BOX 2909, M/S 2151             
;;;   AUSTIN, TEXAS 78769                 
;;;
;;; Copyright (C) 1989 Texas Instruments Incorporated.
;;; All rights reserved.

;;; Patch file for GRAPHICS-WINDOW version 6.1
;;; Written 10/11/89 15:37:45 by MARKY,
;;; while running on LIBRA from band LOD1
;;; With SYSTEM 6.20, VIRTUAL-MEMORY 6.2, EH 6.5, MAKE-SYSTEM 6.2, MICRONET 6.0, LOCAL-FILE 6.1,
;;;  BASIC-PATHNAME 6.2, NETWORK-SUPPORT-COLD 6.2, BASIC-NAMESPACE 6.4, NETWORK-NAMESPACE 6.0,
;;;  DISK-IO 6.1, DISK-LABEL 6.0, BASIC-FILE 6.4, MAC-PATHNAME 6.0, NETWORK-PATHNAME 6.0,
;;;  COMPILER 6.12, TV 6.15, DATALINK 6.0, CHAOSNET 6.1, GC 6.3, MEMORY-AUX 6.0, NVRAM 6.2,
;;;  SYSLOG 6.2, STREAMER-TAPE 6.4, UCL 6.0, INPUT-EDITOR 6.0, METER 6.1, ZWEI 6.7,
;;;  DEBUG-TOOLS 6.3, NETWORK-SUPPORT 6.0, NETWORK-SERVICE 6.1, DATALINK-DISPLAYS 6.0,
;;;  FONT-EDITOR 6.1, SERIAL 6.0, PRINTER 6.3, MAC-PRINTER-TYPES 6.1, PRINTER-TYPES 6.2,
;;;  IMAGEN 6.1, SUGGESTIONS 6.0, MAIL-DAEMON 6.3, MAIL-READER 6.5, TELNET 6.0, VT100 6.0,
;;;  NAMESPACE-EDITOR 6.3, PROFILE 6.2, VISIDOC 6.5, TI-CLOS 6.25, CLEH 6.5, IP 3.52,
;;;  Experimental CLX 6.4, CLUE 6.20, X11M 6.14, Experimental BUG 11.15, Experimental GRAPHICS-WINDOW 6.0,
;;;   microcode 429, Band Name: Rel 6.0 + SLE 9/8

;;; SPR 10179.

#!C
; From file UTILITY.LISP#> GWIN; Hotel:
#10R GWIN#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "GWIN"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: GWIN; UTILITY.#"


(defun nearest-circle-pt (x-point y-point x-center y-center radius)
  "Returns the nearest pt on the circle circumference to x-point, y-point
    by defining a line from the circle center to the point and then going
    radius distance along it."
      
  (let* ((dx (- x-center x-point))
	 (dy (- y-center y-point))
	 (distance (sqrt (+ (* dx dx) (* dy dy))))
	 (distance-to-edge (- distance radius)))	;; may 10/11/89 

    (cond
      ((> radius distance)
       (setq distance-to-edge (- radius distance))
       (values (quotient (- (* x-point (+ radius distance-to-edge))
			    (* distance-to-edge x-center)) radius)
	       (quotient (- (* y-point (+ radius distance-to-edge))
			    (* distance-to-edge y-center)) radius))) 
      
      (t
       (VALUES
	 (+ x-point (/ (* distance-to-edge dx) distance))	;; may 10/11/89 
	 (+ y-point (/ (* distance-to-edge dy) distance)))))))
))
